/*
 * Created on Aug 12, 2003
 */
package DatabaseCommunication;

/**
 * @author student
 *
 * Class Information:
 * Class : DatabaseManager.java
 * Package : DatabaseCommunication
 * Project: Pinboard
 * This class is being used for
 * 
 */
public class DatabaseManager {
	static DatabaseConnection dbcon = new DatabaseConnection();

	/**
	 * Method: main
	 * This method is being used for
	 * @param args void
	 */
	public static void main(String[] args) {
		destroyTables();
		createTables();
	}

	/**
	 * Method: createTables
	 * This method is being used for
	 *  void
	 */
	public static void createTables() {

		String userTable = "CREATE TABLE user (" +
			//"id INT UNSIGNED NOT NULL AUTO_INCREMENT," +
		//"PRIMARY KEY (id),"+
	"loginId CHAR(20) NOT NULL ,"
		+ "PRIMARY KEY (loginId),"
		+ "fName CHAR(40),"
		+ "lName CHAR(40),"
		+ "email CHAR(40),"
		+ "outFrom DATETIME,"
		+ "outTo DATETIME,"
		+ "expiryTime DATETIME);";

		String messageTable =
			"CREATE TABLE message("
				+ "id INT UNSIGNED NOT NULL AUTO_INCREMENT,fromUser CHAR(100),toUser CHAR(100),"
				+ "body CHAR(128),"
				+ "subject CHAR(50),"
				+ "time DATETIME,"
				+ "PRIMARY KEY(id),"
				+ "expiryTime DATETIME);";

		String announcementTable =
			"CREATE TABLE announcement("
				+ "id INT UNSIGNED NOT NULL AUTO_INCREMENT,fromUser CHAR(100),"
				+ "body CHAR(128),"
				+ "subject CHAR(50),"
				+ "time DATETIME,"
				+ "PRIMARY KEY (id),"
				+ "expiryTime DATETIME);";

		dbcon.createTables(userTable);
		dbcon.createTables(messageTable);
		dbcon.createTables(announcementTable);

	}

	/**
	 * Method: destroyTables
	 * This method is being used for
	 *  void
	 */
	public static void destroyTables() {
		String destroyUser = "DROP TABLE IF EXISTS user";
		String destroyMessage = "DROP TABLE IF EXISTS message";
		String destroyAnnouncement = "DROP TABLE IF EXISTS announcement";
		dbcon.destroyTables(destroyUser);
		dbcon.destroyTables(destroyMessage);
		dbcon.destroyTables(destroyAnnouncement);
	}

}
